import 'dotenv/config';
import ExpressService from './expressService.js';

async function main() {
  try {
    console.log('Starting TLC Homes Newsletter Backend...');
    
    const expressService = new ExpressService();
    await expressService.start();
  } catch (error) {
    console.error('Fatal error starting server:', error);
    process.exit(1);
  }
}

process.on('uncaughtException', (error) => {
  console.error('Uncaught Exception:', error);
  process.exit(1);
});

process.on('unhandledRejection', (reason, promise) => {
  console.error('Unhandled Rejection at:', promise, 'reason:', reason);
  process.exit(1);
});

main();