import articlesData from '../../data/articles.js';

class ArticleService {
  /**
   * Get all articles (regardless of status)
   * Filtering by status is handled on the frontend in BlogsView
   */
  static getAllArticles() {
    return articlesData.articles;
  }

  /**
   * Search articles by title
   */
  static searchArticles(query) {
    const articles = this.getAllArticles();
    if (!query) return articles;

    const lowerQuery = query.toLowerCase();
    return articles.filter(article =>
      article.title.toLowerCase().includes(lowerQuery)
    );
  }

  /**
   * Get article formatted for email notification
   */
  static getArticleForEmail(slug) {
    const article = articlesData.articles.find(a => a.slug === slug);
    if (!article) return null;

    return {
      title: article.title,
      excerpt: article.excerpt,
      link: article.url,
      featured_image_url: article.featured_image_url,
      imageUrl: article.featured_image_url, // Keep for backward compatibility with email templates
      author: article.author,
      publish_date: article.publish_date,
      publishedDate: new Date(article.publish_date).toLocaleDateString('en-US', {
        year: 'numeric',
        month: 'long',
        day: 'numeric'
      }),
      category: article.category,
      tags: article.tags,
      status: article.status,
      slug: article.slug,
      url: article.url
    };
  }
}

export default ArticleService;